<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title"><?php echo app('translator')->getFromJson( 'restaurant.reservation_details' ); ?></h4>
            </div>

            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-6">
                        <strong><?php echo app('translator')->getFromJson('contact.customer'); ?>:</strong> <?php echo e($reservation->customer->name, false); ?><br>
                        <strong><?php echo app('translator')->getFromJson('restaurant.service_staff'); ?>:</strong> <?php echo e($reservation->waiter->user_full_name ?? '--', false); ?><br>
                        <strong><?php echo app('translator')->getFromJson('restaurant.correspondent'); ?>:</strong> <?php echo e($reservation->correspondent->user_full_name ?? '--', false); ?><br>
                        <?php if(!empty($reservation->reservation_note)): ?>
                        <strong><?php echo app('translator')->getFromJson('restaurant.customer_note'); ?>:</strong> <?php echo e($reservation->reservation_note, false); ?>

                        <?php endif; ?>
                    </div>
                    <div class="col-sm-6">
                        <strong><?php echo app('translator')->getFromJson('messages.location'); ?>:</strong> <?php echo e($reservation->location->name, false); ?><br>
                        <strong><?php echo app('translator')->getFromJson('restaurant.rooms'); ?>:</strong> <?php echo e($reservation->rooms->name ?? '--', false); ?><br>
                        <strong><?php echo app('translator')->getFromJson('restaurant.reservation_starts'); ?>:</strong> <?php echo e($reservation_start, false); ?><br>
                        <strong><?php echo app('translator')->getFromJson('restaurant.reservation_ends'); ?>:</strong> <?php echo e($reservation_end, false); ?>

                    </div>
                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-sm-12">
                        <button type="button" class="btn btn-info btn-modal pull-right" data-href="<?php echo e(action('NotificationController@getTemplate', ['transaction_id' => $reservation->id,'template_for' => 'new_reservation']), false); ?>" data-container=".view_modal"><?php echo app('translator')->getFromJson('restaurant.send_notification_to_customer'); ?></button>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-sm-9">
                        <?php echo Form::open(['url' => action('ReservationController@update', [$reservation->id]), 'method' => 'PUT', 'id' => 'edit_reservation_form' ]); ?>

                            <div class="input-group">
                                <!-- /btn-group -->
                                <?php echo Form::select('reservation_status', $reservation_statuses, $reservation->reservation_status, ['class' => 'form-control', 'placeholder' => __('restaurant.change_reservation_status'), 'required']);; ?>

                                <div class="input-group-btn">
                                  <button type="submit" class="btn btn-primary"><?php echo app('translator')->getFromJson('messages.update'); ?></button>
                                </div>
                             </div>
                        <?php echo Form::close(); ?>

                    </div>
                    <div class="col-sm-3 text-center">
                        <button type="button" class="btn btn-danger" id="delete_reservation" data-href="<?php echo e(action('ReservationController@destroy', [$reservation->id]), false); ?>"><?php echo app('translator')->getFromJson('room.delete_reservation'); ?></button>
                    </div>
                </div>
            <br>
            <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->getFromJson( 'messages.close' ); ?></button>
            </div>
        

    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->

<?php /**PATH /home/bigdukac/tgr.bigduka.com/resources/views/reservation/show.blade.php ENDPATH**/ ?>