@extends('layouts.app')
@section('title', 'Rooms')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'room.rooms' )
        <small>@lang( 'room.manage_your_rooms' )</small>
    </h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __( 'room.all_your_rooms' )])
        @can('room.create')
            @slot('tool')
                <div class="box-tools">
                    <button type="button" class="btn btn-block btn-primary btn-modal" 
                        data-href="{{action('RoomController@create')}}" 
                        data-container=".rooms_modal">
                        <i class="fa fa-plus"></i> @lang( 'messages.add' )</button>
                </div>
            @endslot
        @endcan
        @can('room.view')
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="rooms_table">
                    <thead>
                        <tr>
                            <th>@lang( 'room.rooms' )</th>
                            <th>@lang( 'room.note' )</th>
                            <th>@lang( 'messages.action' )</th>
                        </tr>
                    </thead>
                </table>
            </div>
        @endcan
    @endcomponent

    <div class="modal fade rooms_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

@endsection


