<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Reservation extends Model
{
    //Allowed reservation statuses ('waiting', 'booked', 'completed', 'cancelled')

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    public function customer()
    {
        return $this->belongsTo(\App\Contact::class, 'contact_id');
    }

    public function table()
    {
        return $this->belongsTo(\App\Restaurant\ResTable::class, 'table_id');
    }

    public function correspondent()
    {
        return $this->belongsTo(\App\User::class, 'correspondent_id');
    }

    public function rooms()
    {
        return $this->belongsTo(\App\Rooms::class, 'rooms_id');
    }

    public function waiter()
    {
        return $this->belongsTo(\App\User::class, 'waiter_id');
    }

    public function location()
    {
        return $this->belongsTo(\App\BusinessLocation::class, 'location_id');
    }

    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    public static function createReservation($input)
    {

        $data = [
            'contact_id' => $input['contact_id'],
            'waiter_id' => isset($input['res_waiter_id']) ? $input['res_waiter_id'] : null,
            'table_id' => isset($input['res_table_id']) ? $input['res_table_id'] : null,
            'business_id' => $input['business_id'],
            'rooms_id' => isset($input['rooms']) ? $input['rooms'] : null,
            'location_id' => $input['location_id'],
            'correspondent_id' => isset($input['correspondent']) ? $input['correspondent'] : null,
            'reservation_start' => $input['reservation_start'],
            'reservation_end' => $input['reservation_end'],
            'created_by' => $input['created_by'],
            'reservation_status' => isset($input['reservation_status']) ? $input['reservation_status'] : 'booked',
            'reservation_note' => $input['reservation_note']
        ];
        $reservation = Reservation::create($data);

        return $reservation;
    }
}


