<?php $__env->startSection('title', __('restaurant.reservations')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo app('translator')->getFromJson( 'restaurant.reservations' ); ?></h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <?php if(count($business_locations) > 1): ?>
        <div class="col-sm-12">
            <select id="business_location_id" class="select2" style="width:50%">
                <option value=""><?php echo app('translator')->getFromJson('purchase.business_location'); ?></option>
                <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key, false); ?>"><?php echo e($value, false); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
    </div>
    <br>
    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo app('translator')->getFromJson('restaurant.todays_reservations'); ?></h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <table class="table table-bordered table-condensed" id="todays_reservations_table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('contact.customer'); ?></th>
                            <th><?php echo app('translator')->getFromJson('restaurant.reservation_starts'); ?></th>
                            <th><?php echo app('translator')->getFromJson('restaurant.reservation_ends'); ?></th>
                            <th><?php echo app('translator')->getFromJson('restaurant.table'); ?></th>
                            <th><?php echo app('translator')->getFromJson('messages.location'); ?></th>
                            <th><?php echo app('translator')->getFromJson('restaurant.service_staff'); ?></th>
                        </tr>
                        </thead>
                    </table>
                </div>
                <!-- /.box-body -->
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-10">
            <div class="box">
                <div class="box-body">
                    <div class="row">
                        <div class="col-sm-12 text-right">
                            <button type="button" class="btn btn-primary" id="add_new_reservation_btn"><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('restaurant.add_reservation'); ?></button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div id="calendar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-2">
            <div class="box box-solid">
                <div class="box-body">
                    <!-- the events -->
                    <div class="external-event bg-yellow text-center" style="position: relative;">
                        <small><?php echo app('translator')->getFromJson('lang_v1.waiting'); ?></small>
                    </div>
                    <div class="external-event bg-light-blue text-center" style="position: relative;">
                        <small><?php echo app('translator')->getFromJson('restaurant.booked'); ?></small>
                    </div>
                    <div class="external-event bg-green text-center" style="position: relative;">
                        <small><?php echo app('translator')->getFromJson('restaurant.completed'); ?></small>
                    </div>
                    <div class="external-event bg-red text-center" style="position: relative;">
                        <small><?php echo app('translator')->getFromJson('restaurant.cancelled'); ?></small>
                    </div>
                    <small>
                    <p class="help-block">
                        <i><?php echo app('translator')->getFromJson('restaurant.click_on_any_reservation_to_view_or_change_status'); ?><br><br>
                        <?php echo app('translator')->getFromJson('restaurant.double_click_on_any_day_to_add_new_reservation'); ?>
                        </i>
                    </p>
                    </small>
                </div>
                <!-- /.box-body -->
            </div>
        </div>
    </div>
<?php echo $__env->make('reservation.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</section>
<!-- /.content -->

<div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    <?php echo $__env->make('contact.create', ['quick_add' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    
    <script type="text/javascript">
        $(document).ready(function(){
            clickCount = 0;
            $('#calendar').fullCalendar({
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'month,agendaWeek,agendaDay,listWeek'
                },
                eventLimit: 2,
                events: '/reservations',
                eventRender: function (event, element) {
                    var title_html = event.customer_name;
                    if(event.table){
                        title_html += '<br>' + event.table;
                    }
                    // title_html += '<br>' + event.start_time + ' - ' + event.end_time;

                    element.find('.fc-title').html(title_html);
                    element.attr('data-href', event.url);
                    element.attr('data-container', '.view_modal');
                    element.addClass('btn-modal');
                },
                dayClick:function( date, jsEvent, view ) {
                    clickCount ++;
                    if( clickCount == 2 ){
                       $('#add_reservation_modal').modal('show');
                       $('form#add_reservation_form #start_time').data("DateTimePicker").date(date).ignoreReadonly(true);
                       $('form#add_reservation_form #end_time').data("DateTimePicker").date(date).ignoreReadonly(true);
                    }
                    var clickTimer = setInterval(function(){
                        clickCount = 0;
                        clearInterval(clickTimer);
                    }, 500);
                }
            });

            //If location is set then show tables.

            $('#add_reservation_modal').on('shown.bs.modal', function (e) {
                getLocationTables($('select#reservation_location_id').val());
                $(this).find('select').each( function(){
                    if(!($(this).hasClass('select2'))){
                        $(this).select2({
                            dropdownParent: $('#add_reservation_modal')
                        });
                    }
                });
                reservation_form_validator = $('form#add_reservation_form').validate({
                    submitHandler: function(form) {
                        var data = $(form).serialize();

                        $.ajax({
                            method: "POST",
                            url: $(form).attr("action"),
                            dataType: "json",
                            data: data,
                            beforeSend: function(xhr) {
                                __disable_submit_button($(form).find('button[type="submit"]'));
                            },
                            success: function(result){
                                if(result.success == true){
                                    if(result.send_notification){
                                        $( "div.view_modal" ).load( result.notification_url,function(){
                                            $(this).modal('show');
                                        });
                                    }

                                    $('div#add_reservation_modal').modal('hide');
                                    toastr.success(result.msg);
                                    reload_calendar();
                                    todays_reservations_table.ajax.reload();
                                } else {
                                    toastr.error(result.msg);
                                }
                                $(form).find('button[type="submit"]').attr('disabled', false);
                            }
                        });
                    }
                });
            });
            $('#add_reservation_modal').on('hidden.bs.modal', function (e) {
                reservation_form_validator.destroy();
                reset_reservation_form();
            });

            $('form#add_reservation_form #start_time').datetimepicker({
                format: moment_date_format + ' ' +moment_time_format,
                minDate: moment(),
                ignoreReadonly: true
            });
            
            $('form#add_reservation_form #end_time').datetimepicker({
                format: moment_date_format + ' ' +moment_time_format,
                minDate: moment(),
                ignoreReadonly: true,
            });

            $('.view_modal').on('shown.bs.modal', function (e) {
                $('form#edit_reservation_form').validate({
                    submitHandler: function(form) {
                        var data = $(form).serialize();

                        $.ajax({
                            method: "PUT",
                            url: $(form).attr("action"),
                            dataType: "json",
                            data: data,
                            beforeSend: function(xhr) {
                                __disable_submit_button($(form).find('button[type="submit"]'));
                            },
                            success: function(result){
                                if(result.success == true){
                                    $('div.view_modal').modal('hide');
                                    toastr.success(result.msg);
                                    reload_calendar();
                                    todays_reservations_table.ajax.reload();
                                    $(form).find('button[type="submit"]').attr('disabled', false);
                                } else {
                                    toastr.error(result.msg);
                                }
                            }
                        });
                    }
                });
            });

            todays_reservations_table = $('#todays_reservations_table').DataTable({
                            processing: true,
                            serverSide: true,
                            "ordering": false,
                            'searching': false,
                            "pageLength": 10,
                            dom:'frtip',
                            "ajax": {
                                "url": '/reservations/get-todays-reservations',
                                "data": function ( d ) {
                                    d.location_id = $('#business_location_id').val();
                                }
                            },
                            columns: [
                                {data: 'customer'},
                                {data: 'reservation_start', name: 'reservation_start'},
                                {data: 'reservation_end', name: 'reservation_end'},
                                {data: 'table'},
                                {data: 'location'},
                                {data: 'waiter'},
                            ]
                        });
            $('button#add_new_reservation_btn').click( function(){
                $('div#add_reservation_modal').modal('show');
            });

        });
        $(document).on('change', 'select#reservation_location_id', function(){
            getLocationTables($(this).val());
        });

        $(document).on('change', 'select#business_location_id', function(){
            reload_calendar();
            todays_reservations_table.ajax.reload();
        });

        $(document).on('click', 'button#delete_reservation', function(){
            swal({
              title: LANG.sure,
              icon: "warning",
              buttons: true,
              dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    var href = $(this).data('href');
                    $.ajax({
                        method: "DELETE",
                        url: href,
                        dataType: "json",
                        success: function(result){
                            if(result.success == true){
                                $('div.view_modal').modal('hide');
                                toastr.success(result.msg);
                                reload_calendar();
                                todays_reservations_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });

        function getLocationTables(location_id){
            $.ajax({
                method: "GET",
                url: '/modules/data/get-pos-details',
                data: {'location_id': location_id},
                dataType: "html",
                success: function(result){
                    $('div#restaurant_module_span').html(result);
                }
            });
        }

        function reset_reservation_form(){
            $('select#reservation_location_id').val('').change();
            // $('select#reservation_customer_id').val('').change();
            $('select#correspondent').val('').change();
            $('#reservation_note, #start_time, #end_time').val('');
        }

        function reload_calendar(){
            var location_id = '';
            if($('select#business_location_id').val()){
                location_id = $('select#business_location_id').val();
            }

            var events_source = {
                url: '/reservations',
                type: 'get',
                data: {
                    'location_id': location_id
                }
            }
            $('#calendar').fullCalendar( 'removeEventSource', events_source);
            $('#calendar').fullCalendar( 'addEventSource', events_source);         
            $('#calendar').fullCalendar( 'refetchEvents' );
        }

        $(document).on('click', '.add_new_customer', function() {
            $('.contact_modal')
                .find('select#contact_type')
                .val('customer')
                .closest('div.contact_type_div')
                .addClass('hide');
            $('.contact_modal').modal('show');
        });
        $('form#quick_add_contact')
            .submit(function(e) {
                e.preventDefault();
            })
            .validate({
                rules: {
                    contact_id: {
                        remote: {
                            url: '/contacts/check-contacts-id',
                            type: 'post',
                            data: {
                                contact_id: function() {
                                    return $('#contact_id').val();
                                },
                                hidden_id: function() {
                                    if ($('#hidden_id').length) {
                                        return $('#hidden_id').val();
                                    } else {
                                        return '';
                                    }
                                },
                            },
                        },
                    },
                },
                messages: {
                    contact_id: {
                        remote: LANG.contact_id_already_exists,
                    },
                },
                submitHandler: function(form) {
                    var data = $(form).serialize();
                    $.ajax({
                        method: 'POST',
                        url: $(form).attr('action'),
                        dataType: 'json',
                        data: data,
                        beforeSend: function(xhr) {
                            __disable_submit_button($(form).find('button[type="submit"]'));
                        },
                        success: function(result) {
                            if (result.success == true) {
                                $('select#reservation_customer_id').append(
                                    $('<option>', { value: result.data.id, text: result.data.name })
                                );
                                $('select#reservation_customer_id')
                                    .val(result.data.id)
                                    .trigger('change');
                                    $('div.contact_modal').modal('hide');
                                toastr.success(result.msg);
                            } else {
                                toastr.error(result.msg);
                            }
                        },
                    });
                },
            });
        $('.contact_modal').on('hidden.bs.modal', function() {
            $('form#quick_add_contact')
                .find('button[type="submit"]')
                .removeAttr('disabled');
            $('form#quick_add_contact')[0].reset();
        });

    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\inetpub\wwwroot\resources\views/reservation/index.blade.php ENDPATH**/ ?>