<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang( 'restaurant.reservation_details' )</h4>
            </div>

            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-6">
                        <strong>@lang('contact.customer'):</strong> {{ $reservation->customer->name }}<br>
                        <strong>@lang('restaurant.service_staff'):</strong> {{ $reservation->waiter->user_full_name ?? '--' }}<br>
                        <strong>@lang('restaurant.correspondent'):</strong> {{ $reservation->correspondent->user_full_name ?? '--' }}<br>
                        @if(!empty($reservation->reservation_note))
                        <strong>@lang('restaurant.customer_note'):</strong> {{ $reservation->reservation_note }}
                        @endif
                    </div>
                    <div class="col-sm-6">
                        <strong>@lang('messages.location'):</strong> {{ $reservation->location->name }}<br>
                        <strong>@lang('restaurant.rooms'):</strong> {{ $reservation->rooms->name ?? '--' }}<br>
                        <strong>@lang('restaurant.reservation_starts'):</strong> {{ $reservation_start }}<br>
                        <strong>@lang('restaurant.reservation_ends'):</strong> {{ $reservation_end }}
                    </div>
                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-sm-12">
                        <button type="button" class="btn btn-info btn-modal pull-right" data-href="{{action('NotificationController@getTemplate', ['transaction_id' => $reservation->id,'template_for' => 'new_reservation'])}}" data-container=".view_modal">@lang('restaurant.send_notification_to_customer')</button>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-sm-9">
                        {!! Form::open(['url' => action('ReservationController@update', [$reservation->id]), 'method' => 'PUT', 'id' => 'edit_reservation_form' ]) !!}
                            <div class="input-group">
                                <!-- /btn-group -->
                                {!! Form::select('reservation_status', $reservation_statuses, $reservation->reservation_status, ['class' => 'form-control', 'placeholder' => __('restaurant.change_reservation_status'), 'required']); !!}
                                <div class="input-group-btn">
                                  <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
                                </div>
                             </div>
                        {!! Form::close() !!}
                    </div>
                    <div class="col-sm-3 text-center">
                        <button type="button" class="btn btn-danger" id="delete_reservation" data-href="{{action('ReservationController@destroy', [$reservation->id])}}">@lang('room.delete_reservation')</button>
                    </div>
                </div>
            <br>
            <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang( 'messages.close' )</button>
            </div>
        

    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->

