<!doctype html>
<html lang="{{ config('app.locale') }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-TC3C83C');</script>
    <!-- End Google Tag Manager -->
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title')</title>


    <!--== bootstrap -->
    <link href="{{ asset('landing/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css"/>

    <link href="https://fonts.googleapis.com/css?family=Dosis:300,400,500,600,700,800" rel="stylesheet">

    <!--== animate -->
    <link href="{{ asset('landing/css/animate.css') }}" rel="stylesheet" type="text/css"/>

    <!--== fontawesome -->
    <link href="{{ asset('landing/css/fontawesome-all.css') }}" rel="stylesheet" type="text/css"/>

    <!--== line-awesome -->
    <link href="{{ asset('landing/css/line-awesome.min.css') }}" rel="stylesheet" type="text/css"/>

    <!--== magnific-popup -->
    <link href="{{ asset('landing/css/magnific-popup/magnific-popup.css') }}" rel="stylesheet" type="text/css"/>

    <!--== owl-carousel -->
    <link href="{{ asset('landing/css/owl-carousel/owl.carousel.css') }}" rel="stylesheet" type="text/css"/>

    <!--== base-theme -->
    <link href="{{ asset('landing/css/base.css') }}" rel="stylesheet" type="text/css"/>

    <!--== default-theme -->
    <link href="{{ asset('landing/css/style.css') }}" rel="stylesheet" type="text/css"/>

    <!--== slider -->
    <link href="{{ asset('landing/css/slider.css') }}" rel="stylesheet" type="text/css"/>

    <!--== responsive -->
    <link href="{{ asset('landing/css/responsive.css') }}" rel="stylesheet" type="text/css"/>

    <!--== color-customizer -->
    <link href="{{ asset('landing/css/theme-color/color-6.css') }}" data-style="styles" rel="stylesheet">

    <style type="text/css">
        .price-value h2 span {
            left: -55px;
        }
    </style>

    <!-- inject css end -->
</head>

<body class="home-6">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TC3C83C"
                  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

<!-- page wrapper start -->

<div class="page-wrapper">

    <!-- preloader start -->

    <div id="ht-preloader">
        <div class="loader clear-loader">
            <div class="loader-box"></div>
            <div class="loader-box"></div>
            <div class="loader-box"></div>
            <div class="loader-box"></div>
            <div class="loader-wrap-text">
                <div class="text">
                    <span>B</span><span>I</span><span>G</span><span>D</span><span>U</span><span>K</span><span>A</span>
                </div>
            </div>
        </div>
    </div>

    <!-- preloader end -->


    <!--header start-->

    <header id="site-header" class="header header-3">
        <div class="container">
            <div id="header-wrap">
                <div class="row">
                    <div class="col-lg-12">
                        <!-- Navbar -->
                        <nav class="navbar navbar-expand-lg">
                            <a class="navbar-brand logo" href="index.html">
                                <img id="logo-white-img" class="img-fluid" src="{{ asset('landing/images/logomain.png ')}}" alt="">
                                <img id="logo-img" class="img-fluid sticky-logo" src="{{ asset('landing/images/logomain.png')}}" alt="">
                            </a>
                            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false"
                                    aria-label="Toggle navigation"><span></span>
                                <span></span>
                                <span></span>
                            </button>
                            <div class="collapse navbar-collapse" id="navbarNav">
                                <!-- Left nav -->
                                <ul class="nav navbar-nav mx-auto">
                                    <!-- Home -->
                                    <li class="nav-item"><a class="nav-link active" href="#home">Home</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="#about">About</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="#service">Services</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="#team">Customers</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="#pricing">Pricing</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="#contacts">Contacts</a>
                                    </li>
                                </ul>
                            </div>
                            <a class="btn btn-theme btn-sm" href="#pricing" data-text="Get Started">
                                <span>Get Started</span>
                            </a>
                            <a class="btn btn-white btn-sm" href="//tgr.bigduka.com/login" data-text="Login">
                                <span>L</span><span>o</span><span>g</span><span>i</span><span>n</span>
                            </a>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!--header end-->


    <!--hero section start-->

    <section id="home" class="fullscreen-banner banner p-0 theme-bg position-relative overflow-hidden"
             data-bg-img="images/bg/08.png">
        <div class="bg-animation">
            <img class="zoom-fade" src="{{ asset('landing/images/pattern/03.png')}}" alt="">
        </div>
        <div class="align-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="bnr-box box-shadow px-5 py-5 xs-px-2 xs-py-2 rounded"
                             data-bg-img="images/bg/06.png">
                            <div class="row align-items-center">
                                <div class="col-lg-5 col-md-12 order-lg-1">
                                    <div class="fnc-slider example-slider">
                                        <div class="fnc-slider__slides">
                                            <!-- slide start -->
                                            <div class="fnc-slide m--blend-green m--active-slide">
                                                <div class="fnc-slide__inner">
                                                    <div class="fnc-slide__mask">

                                                    </div>
                                                    <div class="fnc-slide__content">
                                                        <h2 class="fnc-slide__heading">

                                                        </h2>

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- slide end -->
                                            <!-- slide start -->
                                            <div class="fnc-slide m--blend-dark">
                                                <div class="fnc-slide__inner">
                                                    <div class="fnc-slide__mask">

                                                    </div>
                                                    <div class="fnc-slide__content">
                                                        <h2 class="fnc-slide__heading">

                                                        </h2>

                                                    </div>
                                                </div>
                                                <!-- slide end -->
                                                <!-- slide start -->
                                                <div class="fnc-slide m--blend-red">
                                                    <div class="fnc-slide__inner">
                                                        <div class="fnc-slide__mask">

                                                        </div>
                                                        <div class="fnc-slide__content">
                                                            <h2 class="fnc-slide__heading">

                                                            </h2>

                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- slide end -->
                                                <!-- slide start -->
                                                <div class="fnc-slide m--blend-blue">
                                                    <div class="fnc-slide__inner">
                                                        <div class="fnc-slide__mask">

                                                        </div>
                                                        <div class="fnc-slide__content">
                                                            <h2 class="fnc-slide__heading">

                                                            </h2>

                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- slide end -->
                                            </div>
                                            <nav class="fnc-nav">
                                                <div class="fnc-nav__bgs">
                                                    <div class="fnc-nav__bg m--navbg-green m--active-nav-bg"></div>
                                                    <div class="fnc-nav__bg m--navbg-dark"></div>
                                                    <div class="fnc-nav__bg m--navbg-red"></div>
                                                    <div class="fnc-nav__bg m--navbg-blue"></div>
                                                </div>
                                                <div class="fnc-nav__controls">
                                                    <button class="fnc-nav__control">
                                                        Portable Devices
                                                        <span class="fnc-nav__control-progress"></span>
                                                    </button>
                                                    <button class="fnc-nav__control">
                                                        Wide Screen
                                                        <span class="fnc-nav__control-progress"></span>
                                                    </button>
                                                    <button class="fnc-nav__control">
                                                        Customer Display
                                                        <span class="fnc-nav__control-progress"></span>
                                                    </button>
                                                    <button class="fnc-nav__control">
                                                        Sell & Print
                                                        <span class="fnc-nav__control-progress"></span>
                                                    </button>
                                                </div>
                                            </nav>
                                        </div>
                                        <!-- slider end -->
                                    </div>
                                </div>
                                <div class="col-lg-7 col-md-12 mt-5 mt-lg-0 wow jello" data-wow-duration="1.5s">
                                    <h1 class="mb-4 text-white">Bigduka POS The Perfect Solution For Your Business.</h1>
                                    <p class="lead mb-4 text-white">Works perctly well Accross all devices and
                                        platforms.</p>
                                    <a class="btn btn-white" href="#" data-text="Start A Today">
                                        <span>S</span><span>t</span><span>a</span><span>r</span><span>t</span>
                                        <span> </span><span>A</span>
                                        <span> </span><span>T</span><span>o</span><span>d</span><span>a</span><span>y</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--hero section end-->


    <!--body content start-->

    <div class="page-content">

        <!--feature start-->

        <section class="position-relative bg-effect-2 text-center pb-0" id="service">
            <div class="container z-index-1">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-software"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Business Management</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Allow your business to adapt to market changes, and anticipate business trends by
                                    integrating all business processes into a single system.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-md-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-scroll"></i>
                            </div>
                            <div class="featured-title">
                                <h5>24HRS Support</h5>
                            </div>
                            <div class="featured-desc">
                                <p>At bigduka we provide 24hrs support to our clients. Our technical team is always in
                                    high alight to provide solutions to our clients.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-md-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-scroll"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Stock Management</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka is designed to help big, small and growing businesses effortlessly manage
                                    their inventory across multiple channels and devices.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-resolution"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Service Management</h5>
                            </div>
                            <div class="featured-desc">
                                <p>If you are looking to improve workflow, decisions, output of information and save
                                    time and money, then Bigduka will aid you to achieve exactly that</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-resolution"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Interactive Reporting</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka comprehensively encompasses dynamic multidimensional reporting, analytics,
                                    dashboards, charts and visualisations - in just a few clicks</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-resolution"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Marketing</h5>
                            </div>
                            <div class="featured-desc">
                                <p>A better way to manage your sales, projects, team, clients & marketing - on a single
                                    platform. Powerful, affordable & easy to use software for your business.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-resolution"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Sms/Email Notifications</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Get to the market faster use Bigduka to reach your customers across all channels and
                                    to recieve desired reports to your mail </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-software"></i>
                            </div>
                            <div class="featured-title">
                                <h5>User Management</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka is built to trace a complete audit trail of account activity and access level
                                    changes to assist you in forensic investigations or compliance audits.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-md-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-scroll"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Commission Agents</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Setup commission agents of your business in Bigduka to trace amounts paind to the
                                    agents and maintain commission records</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-resolution"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Tax Group Taxes</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka allows you to setup Tax groups which do come in handy to users without
                                    accounting backgrounds</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-objective"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Pay Terms & Payment Alerts</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Setup payemnt allerts to be either sent to you or your client via email / sms</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-market"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Product Categories & Sub-Categories</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka enable you to organize products by characteristic or business requirement,
                                    such as billing, size, color etc</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Service</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka software helps to modernise businesses process job orders and collect payment
                                    and so much more</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-market"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Purchases</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Add vendor details to your contacts, and manage all your bills and purchase orders in
                                    a single place</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Sales</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka facilitates you with the required tools to manage sells and generate relevent
                                    sales reports</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Invoicing</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Address all of your unique invoicing needs with Bigduka which also enables you to
                                    cutomize all your invoices and receipts</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Bookings</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka is equpied with powerful tools that aid businesses such as restaurants or
                                    hotels to manage room bookings, tables or order placements in the kitchen</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Customers</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Bigduka helps businesses manage communication with current and potential clients by
                                    making it easy to organize and grow your customer relationships with tracking, data
                                    visualizations, email, and more all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Suppliers</h5>
                            </div>
                            <div class="featured-desc">
                                <p>A beautiful and innovative Procurement and Vendor Management. Bigduka gives you
                                    purchasing workflows, customizable approvals, and spend controls</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Brands</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Similar to the use of categories, Bigduka allows you to manage products using brands
                                    and to be able to analyse treinding brands</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-5">
                        <div class="featured-item style-1">
                            <div class="featured-icon"><i class="flaticon-customer-service"></i>
                            </div>
                            <div class="featured-title">
                                <h5>Roles</h5>
                            </div>
                            <div class="featured-desc">
                                <p>Permissions determine what information users can view and edit within the software
                                    thus Bigduka give you peace of mind that your company's data is secure and protected
                                    since information is kept on a need-to-know basis.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--feature end-->


        <!--counter start-->

        <section class="bg-contain sm-bg-cover md-py-0" data-bg-img="images/bg/05.png">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-6">
                        <div class="counter style-4">
                            <div class="counter-desc">
                                <span class="count-number" data-to="18" data-speed="100"
                                      style="color: #009ed7;">18</span>
                                <h5>Clients Tanzania</h5>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 mt-5 mt-md-0">
                        <div class="counter style-4">
                            <div class="counter-desc">
                                <span class="count-number" data-to="23" data-speed="100"
                                      style="color: #ff0000;">23</span>
                                <h5>Clients kenya</h5>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 mt-5 mt-lg-0">
                        <div class="counter style-4">
                            <div class="counter-desc">
                                <span class="count-number" data-to="13" data-speed="100"
                                      style="color:  #f4d504;">>13</span>
                                <h5>Clients Uganda</h5>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 mt-5 mt-lg-0">
                        <div class="counter style-4">
                            <div class="counter-desc">
                                <span class="count-number" data-to="54" data-speed="100">54</span>
                                <h5>Happy Client</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--counter end-->


        <!--about start-->

        <section class="position-relative py-15 md-py-8" id="FAQs">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-6 col-lg-6 col-md-12 image-column right p-0">
                        <div class="img-box box-shadow rounded">
                            <div class="box-loader"><span></span>
                                <span></span>
                                <span></span>
                            </div>
                            <img class="img-fluid" src="{{ asset('landing/images/FAQs.png')}}" alt="">
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-6 col-md-12 me-auto mt-5 mt-lg-0">
                        <div class="accordion" id="accordion">
                            <div class="accordion-item mb-4">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne" aria-expanded="true"
                                            aria-controls="collapseOne">
                                        FAQs ?
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse border-0 show"
                                     aria-labelledby="headingOne" data-bs-parent="#accordion">
                                    <div class="accordion-body">How do I get your POS implemented in my
                                        business?<br></br> One can either fill out our survey form, write us an email or
                                        call us
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item mb-4">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseTwo" aria-expanded="false"
                                            aria-controls="collapseTwo">
                                        How is our pricing system?
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse border-0"
                                     aria-labelledby="headingTwo" data-bs-parent="#accordion">
                                    <div class="accordion-body">Our prices are tailored to meet our clients budgets.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseThree" aria-expanded="false"
                                            aria-controls="collapseThree">
                                        Your price is way over my budget, what we do ?
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse border-0"
                                     aria-labelledby="headingThree" data-bs-parent="#accordion">
                                    <div class="accordion-body">Clients who have an interest in our services but can not
                                        afford the set prices should not worry. At Bigduka we have room to negotiate
                                        with our clients
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--about end-->


        <!--team start-->

        <section id="team" class="position-relative overflow-hidden theme-bg grediant-overlay"
                 data-bg-img="images/bg/09.jpg" data-overlay="9">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8 col-md-12">
                        <div class="section-title">
                            <div class="title-effect">
                                <div class="bar bar-top"></div>
                                <div class="bar bar-right"></div>
                                <div class="bar bar-bottom"></div>
                                <div class="bar bar-left"></div>
                            </div>
                            <h6 class="text-white">Our Clients</h6>
                            <h2 class="title text-white">Bigduka boasts of a personal relationship with Clients</h2>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="pt-0 custom-mt-10 overflow-hidden">
            <div class="container-fluid p-0">
                <div class="row">
                    <div class="col-xl-10 col-lg-11 ms-auto">
                        <div class="owl-carousel" data-items="3" data-md-items="2" data-sm-items="1"
                             data-autoplay="true">
                            <div class="item">
                                <div class="team-member style-3">
                                    <div class="team-images">
                                        <img class="img-fluid rounded box-shadow"
                                             src="{{ asset('landing/images/customers/Tanzania-Flag.png')}}" alt=""> <a class="team-link"
                                                                                                 href="team-single.html"><i
                                            class="la la-external-link"></i></a>
                                    </div>
                                    <div class="team-description"><span>HB Stores</span>
                                        <h5>Dar-Es-Salaam Tanzania</h5>

                                    </div>
                                </div>
                            </div>
                            <div class="item">
                                <div class="team-member style-3">
                                    <div class="team-images">
                                        <img class="img-fluid rounded box-shadow" src="{{ asset('landing/images/customers/kenya.jpg')}}"
                                             alt=""> <a class="team-link" href="team-single.html"><i
                                            class="la la-external-link"></i></a>
                                    </div>
                                    <div class="team-description"><span>Vasco Shop</span>
                                        <h5>Malindi Kenya</h5>

                                    </div>
                                </div>
                            </div>
                            <div class="item">
                                <div class="team-member style-3">
                                    <div class="team-images">
                                        <img class="img-fluid rounded box-shadow" src="{{ asset('landing/images/customers/vesto.jpg')}}"
                                             alt=""> <a class="team-link" href="team-single.html"><i
                                            class="la la-external-link"></i></a>
                                    </div>
                                    <div class="team-description"><span>The Veesto Market</span>
                                        <h5>Dar-Es-Salaam Tanzania</h5>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--team end-->


        <!--pricing start-->

        <section id="pricing" class="position-relative grey-bg bg-effect-2">
            <div class="container">
                <div class="row justify-content-center text-center">
                    <div class="col-lg-8 col-md-12">
                        <div class="section-title">
                            <div class="title-effect">
                                <div class="bar bar-top"></div>
                                <div class="bar bar-right"></div>
                                <div class="bar bar-bottom"></div>
                                <div class="bar bar-left"></div>
                            </div>
                            <h6>Pricing Plan</h6>
                            <h2 class="title">Choose affordable prices</h2>
                            <p>Choosing affordable prices is Choosing Bigduka. Our prices can be customed in-line to
                                your needs.</p>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-12">
                        <div class="price-table style-4">
                            <div class="price-header">
                                <div class="price-value">
                                    <h2><span>USD</span>15</h2>
                                    <span>Monthly Package</span>
                                </div>
                                <h3 class="price-title">Starter</h3>
                            </div>
                            <div class="price-list">
                                <ul class="list-unstyled">
                                    <li><i class="la la-check"></i> 1-3 Employees</li>
                                    <li><i class="la la-check"></i> Small-Scale Business</li>
                                    <li><i class="la la-check"></i> Customizable Requests</li>
                                    <li><i class="la la-check"></i> Single Branch License</li>
                                    <li><i class="la la-check"></i> Database Management</li>
                                    <li><i class="la la-check"></i> 24/7 Customer Support</li>
                                    <li><i class="la la-check"></i> Access to all Features</li>
                                </ul>
                            </div>
                            <a class="btn btn-white btn-circle mt-4" href="#" data-text="Purchase Now">
                                <span>P</span><span>u</span><span>r</span><span>c</span><span>h</span><span>a</span><span>s</span><span>e</span>
                                <span> </span><span>N</span><span>o</span><span>w</span></a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
                        <div class="price-table style-4 active">
                            <canvas id="canvas"></canvas>
                            <div class="price-header">
                                <div class="price-value">
                                    <h2><span>USD</span>25</h2>
                                    <span>monthly Package</span>
                                </div>
                                <h3 class="price-title">Premium</h3>
                            </div>
                            <div class="price-list">
                                <ul class="list-unstyled">
                                    <li><i class="la la-check"></i> 3-5 Employees</li>
                                    <li><i class="la la-check"></i> Customizable Requests</li>
                                    <li><i class="la la-check"></i> Multiple Branch license</li>
                                    <li><i class="la la-check"></i> Database Management</li>
                                    <li><i class="la la-check"></i> 24/7 Customer Support</li>
                                    <li><i class="la la-check"></i> Access to all Features</li>
                                </ul>
                            </div>
                            <a class="btn btn-white btn-circle mt-4" href="#" data-text="Purchase Now">
                                <span>P</span><span>u</span><span>r</span><span>c</span><span>h</span><span>a</span><span>s</span><span>e</span>
                                <span> </span><span>N</span><span>o</span><span>w</span></a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
                        <div class="price-table style-4">
                            <div class="price-header">
                                <div class="price-value">
                                    <h2><span>USD</span> 50</h2>
                                    <span>Monthly Package</span>
                                </div>
                                <h3 class="price-title">Professional</h3>
                            </div>
                            <div class="price-list">
                                <ul class="list-unstyled">
                                    <li><i class="la la-check"></i> Over 5 Employees</li>
                                    <li><i class="la la-check"></i> Customizable Requests</li>
                                    <li><i class="la la-check"></i> Multiple Branch License</li>
                                    <li><i class="la la-check"></i> Database Management</li>
                                    <li><i class="la la-check"></i> 24/7 Customer Support</li>
                                    <li><i class="la la-check"></i> Access to all Features</li>
                                </ul>
                            </div>
                            <a class="btn btn-white btn-circle mt-4" href="#contacts" data-text="Purchase Now">
                                <span>P</span><span>u</span><span>r</span><span>c</span><span>h</span><span>a</span><span>s</span><span>e</span>
                                <span> </span><span>N</span><span>o</span><span>w</span></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--pricing end-->
        <!--about start-->

        <section class="contact-1" id="contacts">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <img class="img-fluid" src="{{ asset('landing/images/banner/06.png')}}" alt="">
                    </div>
                    <div class="col-lg-6 col-md-12 mt-5 mt-lg-0">
                        <div class="section-title">
                            <div class="title-effect title-effect-2">
                                <div class="ellipse"></div>
                                <i class="la la-info"></i>
                            </div>
                            <h2>Stay Contact Us</h2>
                            <p>Get in touch and let us know how we can help. Fill out the form and we’ll be in touch as
                                soon as possible.</p>
                        </div>
{{--                        <form id="contact-form" method="post" action="php/contact.php">--}}
{{--                            <div class="messages"></div>--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <div class="form-group">--}}
{{--                                        <input id="form_name" type="text" name="name" class="form-control"--}}
{{--                                               placeholder="Type First name" required="required"--}}
{{--                                               data-error="Firstname is required.">--}}
{{--                                        <div class="help-block with-errors"></div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <div class="form-group">--}}
{{--                                        <input id="form_lastname" type="text" name="surname" class="form-control"--}}
{{--                                               placeholder="Type Last name" required="required"--}}
{{--                                               data-error="Lastname is required.">--}}
{{--                                        <div class="help-block with-errors"></div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <div class="form-group">--}}
{{--                                        <input id="form_email" type="email" name="email" class="form-control"--}}
{{--                                               placeholder="Type Email" required="required"--}}
{{--                                               data-error="Valid email is required.">--}}
{{--                                        <div class="help-block with-errors"></div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <div class="form-group">--}}
{{--                                        <input id="form_phone" type="tel" name="phone" class="form-control"--}}
{{--                                               placeholder="Type Phone" required="required"--}}
{{--                                               data-error="Phone is required">--}}
{{--                                        <div class="help-block with-errors"></div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <div class="form-group">--}}
{{--                                        <textarea id="form_message" name="message" class="form-control"--}}
{{--                                                  placeholder="Type Message" rows="4" required="required"--}}
{{--                                                  data-error="Please,leave us a message."></textarea>--}}
{{--                                        <div class="help-block with-errors"></div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-md-12 mt-2">--}}
{{--                                    <button value="Send" class="btn btn-theme btn-circle" data-text="Send Message">--}}
{{--                                        <span>S</span><span>e</span><span>n</span><span>d</span>--}}
{{--                                        <span> </span><span>M</span><span>e</span><span>s</span><span>s</span><span>a</span><span>g</span><span>e</span>--}}
{{--                                    </button>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </form>--}}
                        <ul class="media-icon list-unstyled">
                            <li>Email: <a href="info@bigduka.com"><b>info@bigduka.com</b></a>
                            </li>
                            <li>Kenya: <a href="tel:+254728334900"><b>+254728334900</b></a>
                            <li>Tanzania: <a href="tel:+255762385818"><b>+255762385818</b></a>
                            <li>Uganda: <a href="tel:+256774919429"><b>+256774919429</b></a>
                            </li>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <!--about end-->


        <!--testimonial start-->

        <section class="position-relative overflow-hidden" data-bg-img="images/pattern/01.png">
            <!-- <div class="container">
               <div class="row justify-content-center text-center">
                 <div class="col-lg-8 col-md-12">
                   <div class="section-title">
                     <div class="title-effect title-effect-2">
                       <div class="ellipse"></div> <i class="fas fa-info"></i>
                     </div>
                     <h2 class="title">You Can See our clients feedback What You Say?</h2>
                   </div>
                 </div>
               </div>
               <div class="row">
                 <div class="col-md-12">
                   <div class="owl-carousel" data-items="2" data-sm-items="1" data-margin="50" data-autoplay="true">
                     <div class="item">
                       <div class="testimonial style-4">
                         <div class="testimonial-content">
                           <div class="testimonial-quote"><i class="la la-quote-left"></i>
                           </div>
                           <p>Professional recommended and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit</p>
                         </div>
                         <div class="testimonial-img">
                           <img class="img-fluid zoom-fade" src="{{ asset('landing/images/testimonial/01.jpg')}}" alt="">
                         </div>
                         <div class="testimonial-caption">
                           <h5>Lana Roadse</h5>
                           <label>CEO of Loptus</label>
                         </div>
                       </div>
                     </div>
                     <div class="item">
                       <div class="testimonial style-4">
                         <div class="testimonial-content">
                           <div class="testimonial-quote"><i class="la la-quote-left"></i>
                           </div>
                           <p>Professional recommended and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit</p>
                         </div>
                         <div class="testimonial-img">
                           <img class="img-fluid zoom-fade" src="{{ asset('landing/images/testimonial/02.jpg')}}" alt="">
                         </div>
                         <div class="testimonial-caption">
                           <h5>Lana Roadse</h5>
                           <label>CEO of Loptus</label>
                         </div>
                       </div>
                     </div>
                     <div class="item">
                       <div class="testimonial style-4">
                         <div class="testimonial-content">
                           <div class="testimonial-quote"><i class="la la-quote-left"></i>
                           </div>
                           <p>Professional recommended and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit</p>
                         </div>
                         <div class="testimonial-img">
                           <img class="img-fluid zoom-fade" src="{{ asset('landing/images/testimonial/03.jpg')}}" alt="">
                         </div>
                         <div class="testimonial-caption">
                           <h5>Lana Roadse</h5>
                           <label>CEO of Loptus</label>
                         </div>
                       </div>
                     </div>
                   </div>
                 </div>
               </div>
             </div>-->
        </section>

        <!--testimonial end-->


        <!--blog start-->


        <!--blog end-->


        <!--subscribe start-->

        <section class="p-0 z-index-1">
            <div class="container">
                <div class="row subscribe-inner align-items-center">
                    <div class="col-md-6">
                        <h4>Subscribe Our Newsletter</h4>
                        <p class="lead mb-0">Be the first to know about new features and Applications.</p>
                    </div>
                    <div class="col-md-6">
                        <div class="subscribe-form mt-3 mt-md-0">
                            <form id="mc-form" class="group">
                                <input type="email" value="" name="EMAIL" class="email" id="mc-email"
                                       placeholder="Email Address" required="">
                                <input class="btn btn-theme" type="submit" name="subscribe" value="Subscribe">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--subscribe end-->

    </div>

    <!--body content end-->


    <!--footer start-->

    <footer class="footer footer-3 position-relative overflow-hidden custom-mt-10 z-index-0" data-bg-color="#ffe2e1">
        <div id="footer-wave">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1170 193">
                <path d="M1175 131.2c0 0-81-89.4-224.3-103.4S713 72 665 97c-86 46-148 63-271 7C221.7 25.5 56 104.5-4 197.4 -4 58.7-3.3 0.3-3.3 0.3L1175 0V131.2z"></path>
            </svg>
        </div>
        <div class="primary-footer">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="footer-logo">
                            <img id="footer-logo-img" src="{{ asset('landing/images/logomain.png')}}" class="img-fluid" alt="">
                        </div>
                        <p class="mb-0" id="about">Bigduka POS Software is Point Of Sale Software that facilitates the
                            smooth running of a business. This can be from small scale business to Corporations</p>
                    </div>
                    <div class="col-lg-4 col-md-6 ps-md-5 mt-5 mt-md-0 footer-list justify-content-between d-flex">
                        <ul class="list-unstyled w-100">

                            <li><a href="#service">Service</a>
                            </li>
                            <li><a href="#FAQs">FAQs</a>
                            </li>
                            <li><a href="team-single.html">Customers</a>
                            </li>
                            <li><a href="#contacts">Contact Us</a>
                            </li>
                        </ul>
                        <ul class="list-unstyled w-100">
                            <li><a href="#">Privacy Policy</a>
                            </li>
                            <li><a href="#">Terms</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
                        <ul class="media-icon list-unstyled">
                            <li>Email: <a href="info@bigduka.com"><b>info@bigduka.com</b></a>
                            </li>
                            <li>Kenya: <a href="tel:+254728334900"><b>+254728334900</b></a>
                            <li>Tanzania: <a href="tel:+255762385818"><b>+255762385818</b></a>
                            <li>Uganda: <a href="tel:+256774919429"><b>+256774919429</b></a>
                            </li>
                            </li>
                        </ul>
                        <div class="social-icons social-colored circle mt-3">
                            <ul>
                                <li class="social-facebook"><a href="#"><i class="fab fa-facebook-f"></i></a>
                                </li>
                                <li class="social-twitter"><a href="#"><i class="fab fa-twitter"></i></a>
                                </li>
                                <li class="social-gplus"><a href="#"><i class="fab fa-google-plus-g"></i></a>
                                </li>
                                <li class="social-linkedin"><a href="#"><i class="fab fa-linkedin-in"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="secondary-footer text-center">
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-12"><span>Copyright <script
                                type="text/javascript">document.write(new Date().getFullYear());</script> Bigduka <u><a
                                href="#"></a></u> | All Rights Reserved</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!--footer end-->


</div>

<!-- page wrapper end -->


<!--back-to-top start-->

<div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-go-up-in-web"></i></a></div>


<!-- Scripts -->
<script src="{{ asset('js/login.js?v=' . $asset_v) }}"></script>


<!-- inject js start -->

<!--== jquery -->
<script src="{{ asset('landing/js/theme.js')}}"></script>

<!--== owl-carousel -->
<script src="{{ asset('landing/js/owl-carousel/owl.carousel.min.js')}}"></script>

<!--== magnific-popup -->
<script src="{{ asset('landing/js/magnific-popup/jquery.magnific-popup.min.js')}}"></script>

<!--== counter -->
<script src="{{ asset('landing/js/counter/counter.js')}}"></script>

<!--== countdown -->
<script src="{{ asset('landing/js/countdown/jquery.countdown.min.js')}}"></script>

<!--== canvas -->
<script src="{{ asset('landing/js/canvas.js')}}"></script>

<!--== confetti -->
<script src="{{ asset('landing/js/confetti.js')}}"></script>

<!--== step animation -->
<script src="{{ asset('landing/js/snap.svg.js')}}"></script>
<script src="{{ asset('landing/js/step.js')}}"></script>

<!--== contact-form -->
<script src="{{ asset('landing/js/contact-form/contact-form.js')}}"></script>

<!--== wow -->
<script src="{{ asset('landing/js/wow.min.js')}}"></script>

<!--== slider -->
<script src="{{ asset('landing/js/slider.js')}}"></script>

<!--== theme-script -->
<script src="{{ asset('landing/js/theme-script.js')}}"></script>

<!-- inject js end -->
@yield('javascript')
</body>
</html>
